IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_ESTONO_QUITACOES]'))
DROP VIEW [dbo].[V_ESTONO_QUITACOES]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--SELECT TOP 200 * FROM V_QUITACOES
CREATE VIEW [dbo].[V_ESTONO_QUITACOES] AS 

/*QUITACAO DE FATURAS*/ 
SELECT	
	PDV_CUPOM_NAO_FISCAL.CD_EMP, 
	PDV_CUPOM_NAO_FISCAL.CD_FILIAL, 
	PDV_CUPOM_NAO_FISCAL.CD_CX,
	PDV_CUPOM_NAO_FISCAL.DT_CUPOM,
	PDV_CUPOM_NAO_FISCAL.CD_CTR AS CD_CTR_CUPOM, 
	RC_PGTO_PDV.CD_CTR_PGTO, 
	RC_DEB.CD_RC_DEB AS CD_CTR_PARC,
	RC_DEB.CD_RC_DEB,
	BC_LANC.CD_BC_LANC,
	VLR_LANC,
	RC_DEB.SLD_DP,
	RC_CRED.VL_PGTO,
	0 AS VLR_CRED,
	RC_CRED.VL_JUR

FROM RC_PGTO_PDV_RC_CRED INNER JOIN RC_CRED ON 
	RC_PGTO_PDV_RC_CRED.CD_EMP = RC_CRED.CD_EMP AND 
	RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_CRED.CD_FILIAL AND 
	RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_CRED.CD_RC_DEB AND 
	RC_PGTO_PDV_RC_CRED.CD_DP_LANC = RC_CRED.CD_DP_LANC 

	INNER JOIN RC_DEB ON 
	RC_PGTO_PDV_RC_CRED.CD_EMP = RC_DEB.CD_EMP AND 
	RC_PGTO_PDV_RC_CRED.CD_FILIAL = RC_DEB.CD_FILIAL AND 
	RC_PGTO_PDV_RC_CRED.CD_RC_DEB = RC_DEB.CD_RC_DEB 

	INNER JOIN RC_CRED_BC_LANC ON
	RC_CRED_BC_LANC.CD_EMP=RC_CRED.CD_EMP AND
	RC_CRED_BC_LANC.CD_FILIAL=RC_CRED.CD_FILIAL AND
	RC_CRED_BC_LANC.CD_RC_DEB=RC_CRED.CD_RC_DEB 

	INNER JOIN BC_LANC ON
	BC_LANC.CD_EMP=RC_CRED_BC_LANC.CD_EMP AND
	BC_LANC.CD_BC_LANC=RC_CRED_BC_LANC.CD_BC_LANC 

	INNER JOIN RC_PGTO_PDV ON 
	RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV_RC_CRED.CD_CTR_PGTO 

	INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV ON 
	PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR_PGTO = RC_PGTO_PDV.CD_CTR_PGTO 

	INNER JOIN PDV_CUPOM_NAO_FISCAL ON
	PDV_CUPOM_NAO_FISCAL.CD_EMP=PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_EMP AND
	PDV_CUPOM_NAO_FISCAL.CD_FILIAL=PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_FILIAL AND
	PDV_CUPOM_NAO_FISCAL.CD_CTR=PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV.CD_CTR

	   
UNION ALL

/*ANTECIPACOES DE COMPRA*/ 

SELECT
	A.CD_EMP,
	A.CD_FILIAL,
	A.CD_CX,
	A.DT_CUPOM,
	A.CD_CTR AS CD_CTR_CUPOM,
	C.CD_CTR_PGTO,
	H.CD_CTR AS CD_CTR_PARC,
	0 AS CD_RC_DEB,
	G.CD_BC_LANC,
	VLR_LANC,
	0 AS SLD_DP,
	0 AS VL_PGTO,
	E.VLR_CRED,
	0 AS VL_JUR

FROM PDV_CUPOM_NAO_FISCAL A INNER JOIN PDV_CUPOM_NAO_FISCAL_RC_PGTO_PDV B ON
	A.CD_EMP=B.CD_EMP AND
	A.CD_FILIAL=B.CD_FILIAL AND
	A.CD_CTR=B.CD_CTR

	INNER JOIN RC_PGTO_PDV C ON
	C.CD_CTR_PGTO=B.CD_CTR_PGTO

	INNER JOIN RC_PGTO_PDV_RC_CREDIARIO_PARC_CRED D ON
	D.CD_CTR_PGTO=C.CD_CTR_PGTO

	INNER JOIN RC_CREDIARIO_PARC_CRED E ON
	E.CD_CTR = D.CD_CTR AND
	E.CD_CTR_CRED=D.CD_CTR_CRED

	INNER JOIN RC_CREDIARIO_PARC H ON
	H.CD_EMP=E.CD_EMP AND
	H.CD_CTR=E.CD_CTR

	INNER JOIN RC_CREDIARIO_PARC_CRED_BC_LANC F ON
	F.CD_CTR=E.CD_CTR AND
	F.CD_CTR_CRED=E.CD_CTR_CRED

	INNER JOIN BC_LANC G ON
	G.CD_EMP=F.CD_EMP AND
	G.CD_BC_LANC=F.CD_BC_LANC
GO


